
import SwiftUI

struct ContentView: View {
   var body: some View {
      VStack {
         Text("Hello World!")
            .padding()
         Button("Run Task") {
            Task {
               await withTaskGroup(of: String.self) { group in
                  group.addTask(priority: .background) {
                     let imageName = await self.loadImage(name: "My Image 1")
                     return imageName
                  }
                  group.addTask(priority: .background) {
                     let imageName = await self.loadImage(name: "My Image 2")
                     return imageName
                  }
                  group.addTask(priority: .background) {
                     let imageName = await self.loadImage(name: "My Image 3")
                     return imageName
                  }
                  for await result in group {
                     print(result)
                  }
               }
            }
         }
      }
   }
   func loadImage(name: String) async -> String {
      try? await Task.sleep(for: .seconds(3))
      return "Name: \(name)"
   }
}

#Preview {
    ContentView()
}
